/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis.rm;

import filenet.vw.base.logging.Logger;
import filenet.ws.listener.axis.rm.WSRMCallbackData;
import filenet.ws.listener.axis.rm.WSRMUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.providers.java.MsgProvider;
import org.apache.sandesha.IStorageManager;
import org.apache.sandesha.RMMessageContext;
import org.apache.sandesha.SandeshaContext;
import org.apache.sandesha.server.MessageValidator;
import org.apache.sandesha.server.RMMessageProcessorIdentifier;
import org.apache.sandesha.server.msgprocessors.FaultProcessor;
import org.apache.sandesha.server.msgprocessors.IRMMessageProcessor;
import org.apache.sandesha.storage.Callback;
import org.apache.sandesha.storage.CallbackData;
import org.apache.sandesha.ws.rm.RMHeaders;

public class WSRMProvider
extends MsgProvider {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis.rm");
    private static final String m_className = "WSRMProvider";
    private boolean client = false;
    private static Callback callback = null;

    public static String _get_FILE_DATE() {
        return "$Date:   02 Oct 2008 10:24:00  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.3  $";
    }

    public static void setCallback(Callback cb) {
        callback = cb;
    }

    public static void removeCallback() {
        callback = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(MessageContext msgContext, org.apache.axis.message.SOAPEnvelope reqEnv, org.apache.axis.message.SOAPEnvelope resEnv, Object obj) throws Exception {
        block25: {
            String m_method = "processMessage";
            logger.entering(m_className, m_method);
            try {
                if (this.isIgnorableMessage(msgContext) || !WSRMUtils.hasRMHeaders(msgContext)) {
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "Pass message to MsgProvider to handle");
                    }
                    WSRMProvider.displayOperations(m_className, m_method, msgContext, reqEnv);
                    super.processMessage(msgContext, reqEnv, resEnv, obj);
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "Returned from MsgProvider.processMessage(...)");
                    }
                    break block25;
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "a RM Message");
                }
                IStorageManager storageManager = SandeshaContext.init((boolean)this.client);
                storageManager.init();
                RMMessageContext rmMessageContext = new RMMessageContext();
                rmMessageContext.setMsgContext(msgContext);
                try {
                    MessageValidator.validate((RMMessageContext)rmMessageContext, (boolean)this.client);
                }
                catch (AxisFault af) {
                    FaultProcessor faultProcessor = new FaultProcessor(storageManager, af);
                    if (!faultProcessor.sendFault(rmMessageContext)) {
                        msgContext.setPastPivot(true);
                        msgContext.setResponseMessage(null);
                        logger.exiting(m_className, m_method);
                        return;
                    }
                    logger.exiting(m_className, m_method);
                    return;
                }
                RMHeaders rmHeaders = rmMessageContext.getRMHeaders();
                AddressingHeaders addrHeaders = rmMessageContext.getAddressingHeaders();
                if (null != rmHeaders.getSequence()) {
                    rmMessageContext.setSequenceID(rmHeaders.getSequence().getIdentifier().toString());
                    if (null != rmHeaders.getSequence().getLastMessage()) {
                        rmMessageContext.setLastMessage(true);
                    }
                }
                if (addrHeaders.getMessageID() == null) {
                    rmMessageContext.setMessageID(new Long(System.currentTimeMillis()).toString());
                } else {
                    rmMessageContext.setMessageID(addrHeaders.getMessageID().toString());
                }
                IRMMessageProcessor rmMessageProcessor = RMMessageProcessorIdentifier.getMessageProcessor((RMMessageContext)rmMessageContext, (IStorageManager)storageManager);
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Processor className = " + rmMessageProcessor.getClass().getName());
                }
                if (callback != null) {
                    CallbackData cbData = this.getCallbackData(rmMessageContext);
                    callback.onIncomingMessage(cbData);
                }
                try {
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "START Process RM Message");
                    }
                    if (!rmMessageProcessor.processMessage(rmMessageContext)) {
                        msgContext.setPastPivot(true);
                        if (logger.isFinest()) {
                            logger.finest(m_className, m_method, "Response message set to null");
                        }
                        msgContext.setResponseMessage(null);
                    } else {
                        msgContext.setPastPivot(true);
                    }
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "END Process RM Message");
                    }
                }
                catch (AxisFault af) {
                    FaultProcessor faultProcessor = new FaultProcessor(storageManager, af);
                    if (!faultProcessor.sendFault(rmMessageContext)) {
                        msgContext.setPastPivot(true);
                        msgContext.setResponseMessage(null);
                        logger.exiting(m_className, m_method);
                        return;
                    }
                    logger.exiting(m_className, m_method);
                    return;
                }
            }
            finally {
                logger.exiting(m_className, m_method);
            }
        }
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    private boolean isIgnorableMessage(MessageContext msgContext) throws Exception {
        String m_method = "isIgnorableMessage";
        boolean result = false;
        AddressingHeaders addrH = new AddressingHeaders((SOAPEnvelope)msgContext.getRequestMessage().getSOAPEnvelope());
        List lst = this.getIgnorableActions(msgContext);
        if (lst != null && addrH.getAction() != null) {
            for (String str : lst) {
                if (!str.equals(addrH.getAction().toString())) continue;
                result = true;
            }
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "Action = " + addrH.getAction());
            logger.finest(m_className, m_method, "Message ignored = " + result);
        }
        return result;
    }

    private List getIgnorableActions(MessageContext msgContext) {
        SOAPService soapService = msgContext.getService();
        Hashtable options = soapService.getOptions();
        Iterator ite = options.keySet().iterator();
        ArrayList actionList = new ArrayList();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            if (!key.regionMatches(0, "ignoreAction", 0, "ignoreAction".length())) continue;
            actionList.add(options.get(key));
        }
        return actionList;
    }

    private CallbackData getCallbackData(RMMessageContext rmMsgContext) {
        WSRMCallbackData data = null;
        try {
            Class.forName("filenet.ws.listener.axis.rm.WSRMCallbackData");
            data = WSRMCallbackData.getIncomingCallbackData(rmMsgContext);
            callback.onIncomingMessage((CallbackData)data);
        }
        catch (ClassNotFoundException ex) {
            data = new CallbackData();
            data.setMessageId(rmMsgContext.getMessageID());
            data.setMessageType(rmMsgContext.getMessageType());
            data.setSequenceId(rmMsgContext.getSequenceID());
        }
        return data;
    }

    public static void displayOperations(String className, String method, MessageContext msgContext) {
        try {
            org.apache.axis.message.SOAPEnvelope reqEnv = msgContext.getRequestMessage().getSOAPEnvelope();
            WSRMProvider.displayOperations(className, method, msgContext, reqEnv);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void displayOperations(String className, String method, MessageContext msgContext, org.apache.axis.message.SOAPEnvelope reqEnv) {
        try {
            MessageElement element;
            OperationDesc operation = msgContext.getOperation();
            if (operation != null) {
                WSRMProvider.displayOperation(method, method, operation);
                if (logger.isFinest()) {
                    logger.finest(className, method, "current operation = " + operation.getName());
                }
            } else if (logger.isFinest()) {
                logger.finest(className, method, "NO current operation = ");
            }
            SOAPService service = msgContext.getService();
            ServiceDesc serviceDesc = service.getServiceDescription();
            ArrayList list = serviceDesc.getOperations();
            Iterator ite = list.iterator();
            while (ite.hasNext()) {
                WSRMProvider.displayOperation(className, method, (OperationDesc)ite.next());
            }
            QName opQName = null;
            Vector bodyElements = reqEnv.getBodyElements();
            if (bodyElements.size() > 0 && (element = (MessageElement)bodyElements.get(0)) != null) {
                opQName = new QName(element.getNamespaceURI(), element.getLocalName());
                if (logger.isFinest()) {
                    logger.finest(className, method, "opQName namespace = " + opQName.getNamespaceURI());
                }
                if (logger.isFinest()) {
                    logger.finest(className, method, "opQName local part = " + opQName.getLocalPart());
                }
                if ((operation = serviceDesc.getOperationByElementQName(opQName)) == null) {
                    if (logger.isFinest()) {
                        logger.finest(className, method, "opQName operation = null");
                    }
                } else {
                    WSRMProvider.displayOperation(className, method, operation);
                }
            }
        }
        catch (AxisFault ex) {
            logger.throwing(className, method, ex);
            ex.printStackTrace();
        }
        finally {
            logger.exiting(className, method);
        }
    }

    public static void displayOperation(String className, String method, OperationDesc operation) {
        if (operation == null) {
            return;
        }
        try {
            if (logger.isFinest()) {
                logger.finest(className, method, "Operation name = " + operation.getName());
                logger.finest(className, method, "Operation element QName = " + operation.getElementQName().toString());
                logger.finest(className, method, "Operation method = " + operation.getMethod().getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

